﻿/* Skript zur Demonstration von Unterabfragen in der SELECT-Klausel
 * Als Benutzer SCOTT ausführen
 */
 
-- Abfrage aller Abteilungen und der in ihnen arbeitenden Mitarbeiter
-- Fassung mit herkömmlichen Mitteln
select d.deptno, d.dname, d.loc, count(e.empno) anzahl
  from dept d
  left join emp e on d.deptno = e.deptno
 group by d.deptno, d.dname, d.loc;
 
-- Fassung mit skalarer Unterabfrage
select deptno, dname, loc,
       (select count(*)
          from emp e
         where e.deptno = d.deptno) anzahl
  from dept d;
  
-- Skalare Unterabfrage mit einer einfachen Referenz auf eine Tabelle
select ename, job, sal, 
       (select sum(sal) from emp) sum_sal
  from emp;